/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.writer;

import com.sonatype.nexus.db.migrator.entity.ContentRepositoryEntity;
import com.sonatype.nexus.db.migrator.entity.Entity;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.JdbcBatchItemWriter;

public class ContentRepositoryWriter
implements ItemWriter<Entity> {
    private JdbcBatchItemWriter<Entity> contentRepositoryJdbcWriter;
    private String insertSql;

    public ContentRepositoryWriter(JdbcBatchItemWriter<Entity> contentRepositoryJdbcWriter, String insertSql) {
        this.contentRepositoryJdbcWriter = contentRepositoryJdbcWriter;
        this.insertSql = insertSql;
    }

    @Override
    public void write(List<? extends Entity> items) throws Exception {
        Map<String, List<ContentRepositoryEntity>> repositories = items.stream().map(ContentRepositoryEntity.class::cast).collect(Collectors.groupingBy(ContentRepositoryEntity::getFormat));
        for (Map.Entry<String, List<ContentRepositoryEntity>> entry : repositories.entrySet()) {
            this.writeByFormat(entry.getKey(), entry.getValue());
        }
    }

    private void writeByFormat(String format, List<ContentRepositoryEntity> items) throws Exception {
        this.contentRepositoryJdbcWriter.setSql(this.insertSql.replace("${format}", format));
        this.contentRepositoryJdbcWriter.write(items);
    }

    @Generated
    public ContentRepositoryWriter() {
    }
}

