/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice.web;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ProviderWithDependencies;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class AbstractInjectionProvider<T>
implements ProviderWithDependencies<T> {
    private Key<T> key;
    @Inject
    Injector injector;
    private InjectionPoint constructorInjectionPoint;
    private Set<Dependency<?>> dependencies;

    public AbstractInjectionProvider(Key<T> key) {
        this.key = key;
        this.constructorInjectionPoint = InjectionPoint.forConstructorOf(key.getTypeLiteral());
        HashSet dependencyBuilder = new HashSet();
        dependencyBuilder.addAll(this.constructorInjectionPoint.getDependencies());
        for (InjectionPoint injectionPoint : InjectionPoint.forInstanceMethodsAndFields(key.getTypeLiteral())) {
            dependencyBuilder.addAll(injectionPoint.getDependencies());
        }
        this.dependencies = Collections.unmodifiableSet(dependencyBuilder);
    }

    @Override
    public T get() {
        T t2;
        Constructor<T> constructor = this.getConstructor();
        Object[] params = new Object[constructor.getParameterTypes().length];
        for (Dependency<?> dependency : this.constructorInjectionPoint.getDependencies()) {
            params[dependency.getParameterIndex()] = this.injector.getInstance(dependency.getKey());
        }
        try {
            t2 = constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new ProvisionException("Could not instantiate " + this.key + "", e);
        }
        this.injector.injectMembers(t2);
        return this.postProcess(t2);
    }

    private Constructor<T> getConstructor() {
        return (Constructor)this.constructorInjectionPoint.getMember();
    }

    protected T postProcess(T t2) {
        return t2;
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }
}

