/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.nexus;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.cache.Cache;
import org.sonatype.goodies.common.ComponentSupport;

public class ShiroJCacheAdapter<K, V>
extends ComponentSupport
implements org.apache.shiro.cache.Cache<K, V> {
    private final Cache<K, V> cache;
    private final String name;

    public ShiroJCacheAdapter(Cache<K, V> cache) {
        this.cache = Preconditions.checkNotNull(cache);
        this.name = cache.getName();
    }

    public V get(K key) {
        return this.cache.get(key);
    }

    public V put(K key, V value) {
        return this.cache.getAndPut(key, value);
    }

    public V remove(K key) {
        return this.cache.getAndRemove(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return Iterables.size(this.cache);
    }

    public Set<K> keys() {
        HashSet<K> keys = new HashSet<K>();
        for (Cache.Entry<K, V> entry : this.cache) {
            keys.add(entry.getKey());
        }
        return Collections.unmodifiableSet(keys);
    }

    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (Cache.Entry<K, V> entry : this.cache) {
            values.add(entry.getValue());
        }
        return Collections.unmodifiableCollection(values);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "cache=" + this.cache + ", name='" + this.name + '\'' + '}';
    }
}

