/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.security.SecureRandom;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;

public class BcPBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator) {
        super(cArray, pGPDigestCalculator);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray) {
        this(cArray, new SHA1PGPDigestCalculator());
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, S2K.Argon2Params argon2Params) {
        super(cArray, argon2Params);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator, int n) {
        super(cArray, pGPDigestCalculator, n);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, int n) {
        super(cArray, new SHA1PGPDigestCalculator(), n);
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        super.setSecureRandom(secureRandom);
        return this;
    }

    protected byte[] encryptSessionInfo(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        try {
            BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
            BufferedBlockCipher bufferedBlockCipher = BcUtil.createSymmetricKeyWrapper(true, blockCipher, byArray, new byte[blockCipher.getBlockSize()]);
            byte[] byArray3 = new byte[byArray2.length];
            int n2 = bufferedBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray3, 0);
            n2 += bufferedBlockCipher.doFinal(byArray3, n2);
            return byArray3;
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("encryption failed: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    protected byte[] generateV6KEK(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator(new SHA256Digest());
        hKDFBytesGenerator.init(new HKDFParameters(byArray, null, byArray2));
        int n2 = SymmetricKeyUtils.getKeyLengthInOctets(n);
        byte[] byArray3 = new byte[n2];
        hKDFBytesGenerator.generateBytes(byArray3, 0, byArray3.length);
        return byArray3;
    }

    protected byte[] getEskAndTag(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws PGPException {
        byte[] byArray5 = new byte[byArray.length - 3];
        System.arraycopy(byArray, 1, byArray5, 0, byArray5.length);
        AEADBlockCipher aEADBlockCipher = BcAEADUtil.createAEADCipher(n, n2);
        aEADBlockCipher.init(true, new AEADParameters(new KeyParameter(byArray2), 128, byArray3, byArray4));
        int n3 = aEADBlockCipher.getOutputSize(byArray5.length);
        byte[] byArray6 = new byte[n3];
        int n4 = aEADBlockCipher.processBytes(byArray5, 0, byArray5.length, byArray6, 0);
        try {
            n4 += aEADBlockCipher.doFinal(byArray6, n4);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("cannot encrypt session info", invalidCipherTextException);
        }
        return byArray6;
    }
}

