/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collection;

public class OID {
    public static final OID NULL = new OID();
    public static final String SEPARATOR = "@";
    private final String type;
    private final int hash;

    private OID(String type, int hash) {
        this.type = Preconditions.checkNotNull(type);
        this.hash = hash;
    }

    private OID() {
        this.type = null;
        this.hash = System.identityHashCode(this);
    }

    public String getType() {
        return this.type;
    }

    public int getHash() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OID)) {
            return false;
        }
        OID that = (OID)obj;
        return Objects.equal(this.type, that.type) && Objects.equal(this.hash, that.hash);
    }

    public int hashCode() {
        return Objects.hashCode(this.type, this.hash);
    }

    public String toString() {
        if (this == NULL) {
            return "null";
        }
        return String.format("%s%s%x", this.type, SEPARATOR, this.hash);
    }

    public static OID get(Object obj) {
        if (obj == null) {
            return NULL;
        }
        return new OID(obj.getClass().getName(), System.identityHashCode(obj));
    }

    public static OID oid(Object obj) {
        return OID.get(obj);
    }

    public static OID parse(String spec) {
        assert (spec != null);
        String[] items = spec.split(SEPARATOR);
        if (items.length != 2) {
            throw new IllegalArgumentException();
        }
        return new OID(items[0], Integer.parseInt(items[1], 16));
    }

    public static String render(Object obj) {
        assert (obj != null);
        return OID.get(obj).toString();
    }

    public static <T> T find(Collection<T> items, String id) {
        assert (items != null);
        assert (id != null);
        for (T item : items) {
            if (!OID.render(item).equals(id)) continue;
            return item;
        }
        return null;
    }

    public static <T> T find(Collection<T> items, OID id) {
        assert (id != null);
        return OID.find(items, id.toString());
    }
}

