/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;

public final class SafeIterator<T>
implements Iterator<T> {
    private static final Logger log = Loggers.getLogger(SafeIterator.class);
    private final Iterator<T> delegate;
    private T next;

    public SafeIterator(Iterator<T> delegate) {
        this.delegate = Preconditions.checkNotNull(delegate);
    }

    @Override
    public boolean hasNext() {
        while (this.delegate.hasNext()) {
            try {
                this.next = this.delegate.next();
                return true;
            }
            catch (Exception e) {
                log.trace("Skipping bad element", e);
            }
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static <T> SafeIterator<T> of(Iterator<T> iterator) {
        return new SafeIterator<T>(iterator);
    }

    public static <T> SafeIterator<T> of(Iterable<T> iterable) {
        return new SafeIterator<T>(iterable.iterator());
    }
}

