/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.i18n;

import com.google.common.base.Preconditions;
import org.sonatype.goodies.i18n.MessageSource;

public class PrefixingMessageSource
implements MessageSource {
    private final MessageSource messages;
    private final String prefix;

    public PrefixingMessageSource(MessageSource messages, String prefix) {
        this.messages = Preconditions.checkNotNull(messages);
        this.prefix = Preconditions.checkNotNull(prefix);
    }

    protected String createCode(String code) {
        Preconditions.checkNotNull(code);
        return this.prefix + code;
    }

    @Override
    public String getMessage(String code) {
        return this.messages.getMessage(this.createCode(code));
    }

    @Override
    public String getMessage(String code, String defaultValue) {
        return this.messages.getMessage(this.createCode(code), defaultValue);
    }

    @Override
    public String format(String code, Object ... args) {
        return this.messages.format(this.createCode(code), args);
    }
}

