/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.lifecycle;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.goodies.lifecycle.LifecycleAware;

public class Lifecycles {
    private static final Logger log = LoggerFactory.getLogger(Lifecycles.class);

    private Lifecycles() {
    }

    public static void start(Lifecycle component) {
        Preconditions.checkNotNull(component);
        try {
            component.start();
        }
        catch (Exception e) {
            throw Lifecycles.propagate(e);
        }
    }

    public static void start(LifecycleAware component) {
        Preconditions.checkNotNull(component);
        Lifecycles.start(component.getLifecycle());
    }

    public static void start(Object component) {
        if (component instanceof Lifecycle) {
            Lifecycles.start((Lifecycle)component);
        } else if (component instanceof LifecycleAware) {
            Lifecycles.start((LifecycleAware)component);
        } else {
            log.warn("Unable to start component; not a lifecycle: {}", component);
        }
    }

    public static void stop(Lifecycle component) {
        Preconditions.checkNotNull(component);
        try {
            component.stop();
        }
        catch (Exception e) {
            throw Lifecycles.propagate(e);
        }
    }

    public static void stop(LifecycleAware component) {
        Preconditions.checkNotNull(component);
        Lifecycles.stop(component.getLifecycle());
    }

    public static void stop(Object component) {
        if (component instanceof Lifecycle) {
            Lifecycles.stop((Lifecycle)component);
        } else if (component instanceof LifecycleAware) {
            Lifecycles.stop((LifecycleAware)component);
        } else {
            log.warn("Unable to stop component; not a lifecycle: {}", component);
        }
    }

    private static RuntimeException propagate(Throwable throwable) {
        Throwables.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable);
    }
}

