/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.audit;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditRecorder;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.text.Strings2;

public abstract class AuditorSupport
extends ComponentSupport {
    protected static final String SYSTEM_CONTEXT = "system";
    protected static final String CREATED_TYPE = "created";
    protected static final String UPDATED_TYPE = "updated";
    protected static final String DELETED_TYPE = "deleted";
    protected static final String PURGE_TYPE = "purged";
    protected static final String CHANGED_TYPE = "changed";
    private static final Joiner LIST_JOINER = Joiner.on(", ").skipNulls();
    private Provider<AuditRecorder> auditRecorder;
    private Map<Class, String> typeLookup = new HashMap<Class, String>();

    @Inject
    public void setAuditRecorder(Provider<AuditRecorder> auditRecorder) {
        this.auditRecorder = auditRecorder;
    }

    protected void registerType(Class type, String name) {
        this.typeLookup.put(type, name);
    }

    protected String type(Class type) {
        String name = this.typeLookup.get(type);
        if (name == null) {
            return Strings2.lower(type.getSimpleName());
        }
        return name;
    }

    private AuditRecorder recorder() {
        Preconditions.checkState(this.auditRecorder != null, "Missing audit-recorder");
        return this.auditRecorder.get();
    }

    @Deprecated
    protected boolean isEnabled() {
        return this.isRecording();
    }

    protected boolean isRecording() {
        return this.recorder().isEnabled() && !EventHelper.isReplicating();
    }

    protected void record(AuditData data) {
        this.recorder().record(data);
    }

    @Nullable
    protected static String string(Object value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    protected static String string(Iterable value) {
        if (value == null) {
            return null;
        }
        return LIST_JOINER.join(value);
    }
}

