/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cache.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cache.CacheBuilder;
import org.sonatype.nexus.common.node.NodeAccess;

@Named(value="default")
@Singleton
public class DefaultCacheBuilderProvider
extends ComponentSupport
implements Provider<CacheBuilder> {
    private final Map<String, Provider<CacheBuilder>> providers;
    private final String name;

    @Inject
    public DefaultCacheBuilderProvider(Map<String, Provider<CacheBuilder>> providers, @Nullable @Named(value="${nexus.cache.provider}") @Nullable @Named(value="${nexus.cache.provider}") String customName, @Named(value="${nexus.orient.enabled:-false}") @Named(value="${nexus.orient.enabled:-false}") boolean orient, NodeAccess nodeAccess) {
        this.providers = Preconditions.checkNotNull(providers);
        this.name = customName != null ? customName : this.getCustomName(orient, nodeAccess);
        Preconditions.checkArgument(!"default".equals(this.name));
        Preconditions.checkState(providers.containsKey(this.name), "Missing cache-builder: %s", (Object)this.name);
    }

    private String getCustomName(@Named(value="nexus.orient.enabled") @Named(value="nexus.orient.enabled") boolean orient, NodeAccess nodeAccess) {
        return orient && nodeAccess.isClustered() ? "hazelcast" : "ehcache";
    }

    @Override
    public CacheBuilder get() {
        Provider<CacheBuilder> provider = this.providers.get(this.name);
        Preconditions.checkState(provider != null, "Cache-builder vanished: %s", (Object)this.name);
        CacheBuilder builder = provider.get();
        this.log.debug("Constructed cache-builder: {} -> {}", (Object)this.name, (Object)builder);
        return builder;
    }
}

