/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cache.internal.ehcache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import javax.annotation.Nullable;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.ehcache.jsr107.EhcacheCachingProvider;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.BindAsLifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;

@Named(value="ehcache")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
public class EhCacheManagerProvider
extends LifecycleSupport
implements Provider<CacheManager> {
    private static final String CONFIG_FILE = "ehcache.xml";
    private final URI configUri;
    private volatile CacheManager cacheManager;

    @Inject
    public EhCacheManagerProvider(ApplicationDirectories directories) {
        Preconditions.checkNotNull(directories);
        File file = new File(directories.getConfigDirectory("fabric"), CONFIG_FILE);
        if (file.exists()) {
            this.configUri = file.toURI();
        } else {
            this.log.warn("Missing configuration: {}", (Object)file.getAbsolutePath());
            this.configUri = null;
        }
    }

    @VisibleForTesting
    public EhCacheManagerProvider(@Nullable URI uri) {
        this.configUri = uri;
    }

    private CacheManager create(@Nullable URI config) {
        CachingProvider provider = Caching.getCachingProvider(EhcacheCachingProvider.class.getName(), EhcacheCachingProvider.class.getClassLoader());
        this.log.info("Creating cache-manager with configuration: {}", (Object)config);
        CacheManager manager = provider.getCacheManager(config, this.getClass().getClassLoader());
        this.log.debug("Created cache-manager: {}", (Object)manager);
        return manager;
    }

    @Override
    public synchronized CacheManager get() {
        Preconditions.checkState(!this.isStopped(), "Cache-manager destroyed");
        if (this.cacheManager == null) {
            this.cacheManager = this.create(this.configUri);
        }
        return this.cacheManager;
    }

    @Override
    protected void doStop() {
        if (this.cacheManager != null) {
            this.cacheManager.close();
            this.log.info("Cache-manager closed");
            this.cacheManager = null;
        }
    }

    @Named
    private static class BindAsLifecycle
    extends BindAsLifecycleSupport<EhCacheManagerProvider> {
        private BindAsLifecycle() {
        }
    }
}

