/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.app;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;

public abstract class ApplicationVersionSupport
extends ComponentSupport
implements ApplicationVersion {
    public static final String UNKNOWN = "UNKNOWN";
    @VisibleForTesting
    static final String VERSION = "version";
    @VisibleForTesting
    static final String BUILD_REVISION = "build.revision";
    @VisibleForTesting
    static final String BUILD_TIMESTAMP = "build.timestamp";
    @VisibleForTesting
    static final String NEXUS2_VERSION = "nexus2.version";
    private static final String RESOURCE_NAME = "version.properties";
    private Properties properties;

    @VisibleForTesting
    Properties getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        Properties props = new Properties();
        URL url = ApplicationVersionSupport.class.getResource(RESOURCE_NAME);
        if (url != null) {
            this.log.debug("Loading properties from: {}", (Object)url);
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream input = url.openStream();){
                    props.load(input);
                    this.log.trace("Loaded properties: {}", (Object)props);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.error("Failed to load properties from: {}", (Object)url, (Object)e);
            }
        } else {
            this.log.error("Missing required resource: {}", (Object)RESOURCE_NAME);
        }
        this.properties = props;
        return this.properties;
    }

    private String property(String key) {
        return this.getProperties().getProperty(key, UNKNOWN);
    }

    @Override
    public String getVersion() {
        return this.property(VERSION);
    }

    @Override
    public String getBrandedEditionAndVersion() {
        String edition = this.getEdition();
        String version = this.getVersion();
        return String.valueOf("OSS".equals(edition) ? String.valueOf(edition) + " " : "") + version;
    }

    @Override
    public String getBuildRevision() {
        return this.property(BUILD_REVISION);
    }

    @Override
    public String getBuildTimestamp() {
        return this.property(BUILD_TIMESTAMP);
    }

    @Override
    public String getNexus2CompatibleVersion() {
        return this.property(NEXUS2_VERSION);
    }
}

