/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.app;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaseUrlHolder {
    private static final Logger log = LoggerFactory.getLogger(BaseUrlHolder.class);
    private static final InheritableThreadLocal<String> baseUrl = new InheritableThreadLocal();
    private static final InheritableThreadLocal<String> relativePath = new InheritableThreadLocal();

    private BaseUrlHolder() {
    }

    public static void set(String url, String newRelativePath) {
        Preconditions.checkNotNull(url);
        Preconditions.checkNotNull(newRelativePath);
        String strippedUrl = BaseUrlHolder.stripSlash(url);
        String strippedRelativePath = BaseUrlHolder.stripSlash(newRelativePath);
        log.trace("Set: {}", (Object)strippedUrl);
        baseUrl.set(strippedUrl);
        log.trace("Set relativePath: {}", (Object)strippedRelativePath);
        relativePath.set(strippedRelativePath);
    }

    private static String stripSlash(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String get() {
        String url = (String)baseUrl.get();
        Preconditions.checkState(url != null, "Base URL not set");
        return url;
    }

    public static String getRelativePath() {
        String url = (String)relativePath.get();
        Preconditions.checkState(url != null, "Relative path not set");
        return url;
    }

    public static void unset() {
        log.trace("Unset");
        baseUrl.remove();
        relativePath.remove();
    }

    public static boolean isSet() {
        return baseUrl.get() != null;
    }

    public static <R> R with(String url, String relative, Supplier<R> operation) {
        BaseUrlHolder.set(url, relative);
        try {
            R r = operation.get();
            return r;
        }
        finally {
            BaseUrlHolder.unset();
        }
    }

    public static <R> R call(String url, String relative, Callable<R> operation) throws Exception {
        BaseUrlHolder.set(url, relative);
        try {
            R r = operation.call();
            return r;
        }
        finally {
            BaseUrlHolder.unset();
        }
    }
}

