/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.app;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class FreezeRequest {
    @Nullable
    private final String token;
    private final String reason;
    private final DateTime frozenAt;
    @Nullable
    private final String frozenBy;
    @Nullable
    private final String frozenByIp;

    public FreezeRequest(@Nullable String token, String reason, DateTime frozenAt, @Nullable String frozenBy, @Nullable String frozenByIp) {
        this.token = token;
        this.reason = Preconditions.checkNotNull(reason);
        this.frozenAt = Preconditions.checkNotNull(frozenAt);
        this.frozenBy = frozenBy;
        this.frozenByIp = frozenByIp;
    }

    public Optional<String> token() {
        return Optional.ofNullable(this.token);
    }

    public boolean isUserRequest() {
        return this.token == null;
    }

    public String reason() {
        return this.reason;
    }

    public DateTime frozenAt() {
        return this.frozenAt;
    }

    public Optional<String> frozenBy() {
        return Optional.ofNullable(this.frozenBy);
    }

    public Optional<String> frozenByIp() {
        return Optional.ofNullable(this.frozenByIp);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "token=" + this.token + ", reason=" + this.reason + ", frozenAt=" + this.frozenAt + ", frozenBy=" + this.frozenBy + ", frozenByIp=" + this.frozenByIp + '}';
    }
}

