/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;

public class DetachingMap<K, V>
extends ForwardingMap<K, V> {
    private Map<K, V> backing;
    private final BooleanSupplier allowDetach;
    private final Function<V, V> detach;
    private boolean detached;

    public DetachingMap(Map<K, V> backing, BooleanSupplier allowDetach, Function<V, V> detach) {
        this.backing = Preconditions.checkNotNull(backing);
        this.allowDetach = Preconditions.checkNotNull(allowDetach);
        this.detach = Preconditions.checkNotNull(detach);
    }

    public DetachingMap(Map<K, V> backing, Function<V, V> detach) {
        this(backing, () -> true, detach);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backing.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backing.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean equals(Object object) {
        return this.backing.equals(object);
    }

    @Override
    public int hashCode() {
        return this.backing.hashCode();
    }

    @Override
    public String toString() {
        return this.backing.toString();
    }

    @Override
    protected Map<K, V> delegate() {
        if (!this.detached && this.allowDetach.getAsBoolean()) {
            HashMap detaching = new HashMap(this.backing.size());
            this.backing.entrySet().forEach((? super T e) -> {
                V v = detaching.put(e.getKey(), this.detach.apply(e.getValue()));
            });
            this.backing = detaching;
            this.detached = true;
        }
        return this.backing;
    }
}

