/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;

public class DetachingSet<V>
extends ForwardingSet<V> {
    private Set<V> backing;
    private final BooleanSupplier allowDetach;
    private final Function<V, V> detach;
    private boolean detached;

    public DetachingSet(Set<V> backing, BooleanSupplier allowDetach, Function<V, V> detach) {
        this.backing = Preconditions.checkNotNull(backing);
        this.allowDetach = Preconditions.checkNotNull(allowDetach);
        this.detach = Preconditions.checkNotNull(detach);
    }

    public DetachingSet(Set<V> backing, Function<V, V> detach) {
        this(backing, () -> true, detach);
    }

    @Override
    public boolean contains(Object key) {
        return this.backing.contains(key);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.backing.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean equals(Object object) {
        return this.backing.equals(object);
    }

    @Override
    public int hashCode() {
        return this.backing.hashCode();
    }

    @Override
    public String toString() {
        return this.backing.toString();
    }

    @Override
    protected Set<V> delegate() {
        if (!this.detached && this.allowDetach.getAsBoolean()) {
            HashSet<V> detaching = new HashSet<V>(this.backing.size());
            this.backing.forEach(e -> {
                boolean bl = detaching.add(this.detach.apply(e));
            });
            this.backing = detaching;
            this.detached = true;
        }
        return this.backing;
    }
}

