/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.cooperation2.internal;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.IOCall;
import org.sonatype.nexus.common.cooperation2.IOCheck;

public abstract class Cooperation2Builder<RET>
implements Cooperation2.Builder<RET> {
    protected boolean performWorkOnFail;
    protected IOCheck<RET> checkFunction = Optional::empty;
    protected final IOCall<RET> workFunction;

    protected Cooperation2Builder(IOCall<RET> workFunction) {
        this.workFunction = Preconditions.checkNotNull(workFunction, "The work function for this co-operation is missing");
    }

    @Override
    public Cooperation2Builder<RET> checkFunction(IOCheck<RET> checkFunction) {
        this.checkFunction = Preconditions.checkNotNull(checkFunction, "The check function for this co-operation is missing");
        return this;
    }

    @Override
    public Cooperation2Builder<RET> performWorkOnFail(boolean performWorkOnFail) {
        this.performWorkOnFail = performWorkOnFail;
        return this;
    }
}

