/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.cooperation2.internal;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.CooperationKey;
import org.sonatype.nexus.common.cooperation2.IOCall;
import org.sonatype.nexus.common.cooperation2.internal.Cooperation2Builder;

public class DisabledCooperation2
extends ComponentSupport
implements Cooperation2 {
    private final String scope;

    public DisabledCooperation2(String scope) {
        this.scope = scope;
    }

    @Override
    public <RET> Cooperation2.Builder<RET> on(IOCall<RET> workFunction) {
        return new DisabledCooperation2Builder<RET>(workFunction);
    }

    @Override
    public Map<String, Integer> getThreadCountPerKey() {
        return Collections.emptyMap();
    }

    private class DisabledCooperation2Builder<R>
    extends Cooperation2Builder<R> {
        DisabledCooperation2Builder(IOCall<R> workFunction) {
            super(workFunction);
        }

        @Override
        public R cooperate(String action, String ... nestedScope) throws IOException {
            CooperationKey cooperationKey = CooperationKey.create(DisabledCooperation2.this.scope, action, nestedScope);
            DisabledCooperation2.this.log.debug("Starting work for {}", (Object)cooperationKey);
            Stopwatch timer = Stopwatch.createStarted();
            try {
                Object t2 = this.workFunction.call();
                return (R)t2;
            }
            finally {
                DisabledCooperation2.this.log.debug("Completed work for {} in {}", (Object)cooperationKey, (Object)timer.elapsed());
            }
        }
    }
}

