/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.entity;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;

public class Continuations {
    private static final String ITERABLE_NON_NULL = "Iterable must be non-null";
    private static final String FUNCTION_NON_NULL = "Browse function must be non-null";
    public static final String LIMIT_NON_NEGATIVE = "Browse limit must be non-negative";
    private static final String PROPERTY_PREFIX = "nexus.continuation.browse.";
    public static final int BROWSE_LIMIT = SystemPropertiesHelper.getInteger("nexus.continuation.browse.limit", 1000);

    private Continuations() {
    }

    public static <T> Stream<T> streamOf(Iterable<T> iterable) {
        Preconditions.checkArgument(iterable != null, ITERABLE_NON_NULL);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> streamOf(BiFunction<Integer, String, Continuation<T>> browseFunction) {
        Preconditions.checkArgument(browseFunction != null, FUNCTION_NON_NULL);
        return Continuations.streamOf(Continuations.iterableOf(browseFunction));
    }

    public static <T> Stream<T> streamOf(BiFunction<Integer, String, Continuation<T>> browseFunction, int limit) {
        Preconditions.checkArgument(browseFunction != null, FUNCTION_NON_NULL);
        Preconditions.checkArgument(limit >= 0, LIMIT_NON_NEGATIVE);
        return Continuations.streamOf(Continuations.iterableOf(browseFunction, limit));
    }

    public static <T> Stream<T> streamOf(BiFunction<Integer, String, Continuation<T>> browseFunction, int limit, String startToken) {
        Preconditions.checkArgument(browseFunction != null, FUNCTION_NON_NULL);
        Preconditions.checkArgument(limit >= 0, LIMIT_NON_NEGATIVE);
        return Continuations.streamOf(Continuations.iterableOf(browseFunction, limit, startToken));
    }

    public static <T> Iterable<T> iterableOf(BiFunction<Integer, String, Continuation<T>> browseFunction) {
        Preconditions.checkArgument(browseFunction != null, FUNCTION_NON_NULL);
        return () -> Continuations.iteratorOf(browseFunction);
    }

    public static <T> Iterable<T> iterableOf(BiFunction<Integer, String, Continuation<T>> browseFunction, int limit) {
        Preconditions.checkArgument(browseFunction != null, FUNCTION_NON_NULL);
        Preconditions.checkArgument(limit >= 0, LIMIT_NON_NEGATIVE);
        return () -> Continuations.iteratorOf(browseFunction, limit);
    }

    public static <T> Iterable<T> iterableOf(BiFunction<Integer, String, Continuation<T>> browseFunction, int limit, String startToken) {
        Preconditions.checkArgument(browseFunction != null, FUNCTION_NON_NULL);
        Preconditions.checkArgument(limit >= 0, LIMIT_NON_NEGATIVE);
        return () -> Continuations.iteratorOf(browseFunction, limit, startToken);
    }

    public static <T> Iterator<T> iteratorOf(BiFunction<Integer, String, Continuation<T>> browseFunction) {
        Preconditions.checkArgument(browseFunction != null, FUNCTION_NON_NULL);
        return Continuations.iteratorOf(browseFunction, BROWSE_LIMIT);
    }

    public static <T> Iterator<T> iteratorOf(BiFunction<Integer, String, Continuation<T>> browseFunction, int limit) {
        return Continuations.iteratorOf(browseFunction, limit, null);
    }

    public static <T> Iterator<T> iteratorOf(final BiFunction<Integer, String, Continuation<T>> browseFunction, final int limit, String startToken) {
        Preconditions.checkArgument(browseFunction != null, FUNCTION_NON_NULL);
        Preconditions.checkArgument(limit >= 0, LIMIT_NON_NEGATIVE);
        return new Iterator<T>(startToken){
            private Continuation<T> continuation;
            private Iterator<T> iterator;
            {
                this.continuation = (Continuation)biFunction.apply(n, string);
                this.iterator = this.continuation.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.continuation.isEmpty()) {
                    return false;
                }
                if (this.iterator.hasNext()) {
                    return true;
                }
                if (this.continuation.size() < limit) {
                    return false;
                }
                return Optional.ofNullable(this.continuation.nextContinuationToken()).map(token -> {
                    this.continuation = (Continuation)browseFunction.apply(limit, token);
                    this.iterator = this.continuation.iterator();
                    return this.iterator.hasNext();
                }).orElse(false);
            }

            @Override
            public T next() {
                return this.iterator.next();
            }
        };
    }
}

