/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.event;

import com.google.common.base.Throwables;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import org.sonatype.nexus.common.event.Slf4jSubscriberExceptionHandler;

public class EventBusFactory {
    private EventBusFactory() {
    }

    public static EventBus reentrantEventBus(String name) {
        return EventBusFactory.newEventBus(name, MoreExecutors.directExecutor());
    }

    public static EventBus reentrantAsyncEventBus(String name, Executor executor) {
        return EventBusFactory.newEventBus(name, executor);
    }

    private static EventBus newEventBus(String name, Executor executor) {
        try {
            Class<?> dispatcherClass = EventBus.class.getClassLoader().loadClass("com.google.common.eventbus.Dispatcher");
            Method immediateDispatcherMethod = dispatcherClass.getDeclaredMethod("immediate", new Class[0]);
            immediateDispatcherMethod.setAccessible(true);
            Constructor eventBusConstructor = EventBus.class.getDeclaredConstructor(String.class, Executor.class, dispatcherClass, SubscriberExceptionHandler.class);
            eventBusConstructor.setAccessible(true);
            Object immediateDispatcher = immediateDispatcherMethod.invoke(null, new Object[0]);
            Slf4jSubscriberExceptionHandler exceptionHandler = new Slf4jSubscriberExceptionHandler(name);
            return (EventBus)eventBusConstructor.newInstance(name, executor, immediateDispatcher, exceptionHandler);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new LinkageError("Unable to create EventBus with custom executor", e);
        }
    }
}

