/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.event;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Slf4jSubscriberExceptionHandler
implements SubscriberExceptionHandler {
    private final Logger logger;

    public Slf4jSubscriberExceptionHandler(String identifier) {
        Preconditions.checkNotNull(identifier);
        this.logger = LoggerFactory.getLogger(String.valueOf(EventBus.class.getName()) + "." + identifier);
    }

    @Override
    public void handleException(Throwable exception, SubscriberExceptionContext context) {
        this.logger.error("Could not dispatch event {} to subscriber {} method [{}]", context.getEvent(), context.getSubscriber(), context.getSubscriberMethod(), exception);
    }
}

