/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.filter;

import com.google.common.base.Preconditions;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ScalableBloomFilter<T> {
    private final List<BloomFilter<T>> filters = new LinkedList<BloomFilter<T>>();
    private final Funnel<? super T> funnel;
    private final int filterCapacity;
    private final double falsePositiveProbability;

    public ScalableBloomFilter(Funnel<? super T> funnel, int filterCapacity, double falsePositiveProbability) {
        Preconditions.checkArgument(filterCapacity > 0, "filter capacity must be greater than 0");
        Preconditions.checkArgument(falsePositiveProbability > 0.0, "fpp must be greater than 0");
        this.funnel = Preconditions.checkNotNull(funnel);
        this.filterCapacity = filterCapacity;
        this.falsePositiveProbability = falsePositiveProbability;
    }

    public boolean mightContain(T input) {
        for (BloomFilter<T> filter : this.filters) {
            if (!filter.mightContain(input)) continue;
            return true;
        }
        return false;
    }

    public boolean put(T input) {
        return !this.mightContain(input) && this.getFilter().put(input);
    }

    public double expectedFpp() {
        double probabilitySum = 0.0;
        double combinatorialAnd = 0.0;
        List probabilities = this.filters.stream().mapToDouble(BloomFilter::expectedFpp).boxed().collect(Collectors.toList());
        int i = 0;
        while (i < probabilities.size()) {
            Double probability = (Double)probabilities.get(i);
            probabilitySum += probability.doubleValue();
            int j = i + 1;
            while (j < probabilities.size()) {
                combinatorialAnd += probability * (Double)probabilities.get(j);
                ++j;
            }
            ++i;
        }
        double andProbability = this.filters.stream().mapToDouble(BloomFilter::expectedFpp).reduce((a, b) -> a * b).getAsDouble();
        return probabilitySum - combinatorialAnd + andProbability;
    }

    private BloomFilter<T> getFilter() {
        if (this.filters.isEmpty()) {
            this.filters.add(this.createFilter());
        }
        if (this.filters.size() == this.filterCapacity) {
            this.filters.add(this.createFilter());
        }
        return this.filters.get(this.filters.size() - 1);
    }

    private BloomFilter<T> createFilter() {
        return BloomFilter.create(this.funnel, this.filterCapacity, this.falsePositiveProbability);
    }
}

