/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.MultiHashingInputStream;

public final class Hashes {
    private Hashes() {
    }

    public static HashCode hash(HashAlgorithm algorithm, InputStream inputStream) throws IOException {
        Preconditions.checkNotNull(algorithm);
        Preconditions.checkNotNull(inputStream);
        Throwable throwable = null;
        Object var3_4 = null;
        try (HashingInputStream hashingStream = new HashingInputStream(algorithm.function(), inputStream);){
            ByteStreams.copy(hashingStream, ByteStreams.nullOutputStream());
            return hashingStream.hash();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Map<HashAlgorithm, HashCode> hash(Iterable<HashAlgorithm> algorithms, InputStream inputStream) throws IOException {
        Preconditions.checkNotNull(algorithms);
        Preconditions.checkNotNull(inputStream);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MultiHashingInputStream hashingStream = new MultiHashingInputStream(algorithms, inputStream);){
            ByteStreams.copy(hashingStream, ByteStreams.nullOutputStream());
            return hashingStream.hashes();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static HashCode hash(HashFunction function, InputStream input) throws IOException {
        Hasher hasher = function.newHasher();
        OutputStream output = Funnels.asOutputStream(hasher);
        ByteStreams.copy(input, output);
        return hasher.hash();
    }
}

