/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sonatype.nexus.common.hash.HashAlgorithm;

public class MultiHashingOutputStream
extends FilterOutputStream {
    private final Map<HashAlgorithm, Hasher> hashers = new LinkedHashMap<HashAlgorithm, Hasher>();

    public MultiHashingOutputStream(Iterable<HashAlgorithm> algorithms, OutputStream out) {
        super(Preconditions.checkNotNull(out));
        Preconditions.checkNotNull(algorithms);
        for (HashAlgorithm algorithm : algorithms) {
            this.hashers.put(algorithm, algorithm.function().newHasher());
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        for (Hasher hasher : this.hashers.values()) {
            hasher.putByte((byte)b);
        }
    }

    public Map<HashAlgorithm, HashCode> hashes() {
        HashMap<HashAlgorithm, HashCode> hashes = new HashMap<HashAlgorithm, HashCode>(this.hashers.size());
        for (Map.Entry<HashAlgorithm, Hasher> entry : this.hashers.entrySet()) {
            hashes.put(entry.getKey(), entry.getValue().hash());
        }
        return hashes;
    }
}

