/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.log;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class MarkedLogger
implements Logger {
    private final Logger delegate;
    private final Marker marker;

    public MarkedLogger(Logger delegate, Marker marker) {
        this.delegate = Preconditions.checkNotNull(delegate);
        this.marker = Preconditions.checkNotNull(marker);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isTraceEnabled(this.marker);
    }

    @Override
    public void trace(String msg) {
        this.trace(this.marker, msg);
    }

    @Override
    public void trace(String format, Object arg) {
        this.trace(this.marker, format, arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.trace(this.marker, format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.trace(this.marker, format, arguments);
    }

    @Override
    public void trace(String msg, Throwable t2) {
        this.trace(this.marker, msg, t2);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    @Override
    public void trace(Marker marker, String msg) {
        this.delegate.trace(marker, msg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        this.delegate.trace(marker, format, arg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.trace(marker, format, arg1, arg2);
    }

    @Override
    public void trace(Marker marker, String format, Object ... argArray) {
        this.delegate.trace(marker, format, argArray);
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t2) {
        this.delegate.trace(marker, msg, t2);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled(this.marker);
    }

    @Override
    public void debug(String msg) {
        this.debug(this.marker, msg);
    }

    @Override
    public void debug(String format, Object arg) {
        this.debug(this.marker, format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.debug(this.marker, format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.debug(this.marker, format, arguments);
    }

    @Override
    public void debug(String msg, Throwable t2) {
        this.debug(this.marker, msg, t2);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    @Override
    public void debug(Marker marker, String msg) {
        this.delegate.debug(marker, msg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        this.delegate.debug(marker, format, arg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.debug(marker, format, arg1, arg2);
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        this.delegate.debug(marker, format, arguments);
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t2) {
        this.delegate.debug(marker, msg, t2);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isInfoEnabled(this.marker);
    }

    @Override
    public void info(String msg) {
        this.info(this.marker, msg);
    }

    @Override
    public void info(String format, Object arg) {
        this.info(this.marker, format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.info(this.marker, format, arg1, arg2);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.info(this.marker, format, arguments);
    }

    @Override
    public void info(String msg, Throwable t2) {
        this.info(this.marker, msg, t2);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    @Override
    public void info(Marker marker, String msg) {
        this.delegate.info(marker, msg);
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        this.delegate.info(marker, format, arg);
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.info(marker, format, arg1, arg2);
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        this.delegate.info(marker, format, arguments);
    }

    @Override
    public void info(Marker marker, String msg, Throwable t2) {
        this.delegate.info(marker, msg, t2);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isWarnEnabled(this.marker);
    }

    @Override
    public void warn(String msg) {
        this.warn(this.marker, msg);
    }

    @Override
    public void warn(String format, Object arg) {
        this.warn(this.marker, format, arg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.warn(this.marker, format, arguments);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.warn(this.marker, format, arg1, arg2);
    }

    @Override
    public void warn(String msg, Throwable t2) {
        this.warn(this.marker, msg, t2);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    @Override
    public void warn(Marker marker, String msg) {
        this.delegate.warn(marker, msg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        this.delegate.warn(marker, format, arg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.warn(marker, format, arg1, arg2);
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        this.delegate.warn(marker, format, arguments);
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t2) {
        this.delegate.warn(marker, msg, t2);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isErrorEnabled(this.marker);
    }

    @Override
    public void error(String msg) {
        this.error(this.marker, msg);
    }

    @Override
    public void error(String format, Object arg) {
        this.error(this.marker, format, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.error(this.marker, format, arg1, arg2);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.error(this.marker, format, arguments);
    }

    @Override
    public void error(String msg, Throwable t2) {
        this.error(this.marker, msg, t2);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isErrorEnabled(marker);
    }

    @Override
    public void error(Marker marker, String msg) {
        this.delegate.error(marker, msg);
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        this.delegate.error(marker, format, arg);
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.delegate.error(marker, format, arg1, arg2);
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        this.delegate.error(marker, format, arguments);
    }

    @Override
    public void error(Marker marker, String msg, Throwable t2) {
        this.delegate.error(marker, msg, t2);
    }
}

