/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.property;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.common.Time;

public class SystemPropertiesHelper {
    private static final Logger log = LoggerFactory.getLogger(SystemPropertiesHelper.class);

    private SystemPropertiesHelper() {
    }

    public static int getInteger(String key, int defaultValue) {
        String value = System.getProperty(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("Invalid integer '{}' for property '{}'. Defaulting to '{}'", value, key, defaultValue);
            return defaultValue;
        }
    }

    public static long getLong(String key, long defaultValue) {
        String value = System.getProperty(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("Invalid long '{}' for property '{}'. Defaulting to '{}'", value, key, defaultValue);
            return defaultValue;
        }
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return SystemPropertiesHelper.getBoolean(key).orElse(defaultValue);
    }

    public static Optional<Boolean> getBoolean(String key) {
        return Optional.ofNullable(System.getProperty(key)).map(String::trim).filter(value -> value.length() > 0).map(Boolean::valueOf);
    }

    public static String getString(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }

    public static Time getTime(String key, Time defaultValue) {
        String value = System.getProperty(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        try {
            return Time.parse(value);
        }
        catch (RuntimeException runtimeException) {
            log.warn("Invalid time '{}' for property '{}'. Defaulting to '{}'", value, key, defaultValue);
            return defaultValue;
        }
    }
}

