/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.sequence;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.sonatype.nexus.common.sequence.NumberSequence;

public class RandomExponentialSequence
implements NumberSequence {
    private final long start;
    private final double factor;
    private final double maxDeviation;
    private final Random random = new Random();
    private Long current;

    public static Builder builder() {
        return new Builder();
    }

    private RandomExponentialSequence(long start, double factor, double maxDeviation) {
        this.start = start;
        this.factor = factor;
        this.maxDeviation = maxDeviation;
        this.reset();
    }

    @Override
    public long next() {
        double deviation = this.random.nextDouble() * this.maxDeviation * (this.random.nextBoolean() ? 1.0 : -1.0);
        long currentValue = this.current;
        this.current = (long)(Math.max(1.0, deviation + this.factor) * (double)this.current.longValue());
        return currentValue;
    }

    @Override
    public long prev() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.current = this.start;
    }

    /* synthetic */ RandomExponentialSequence(long l, double d, double d2, RandomExponentialSequence randomExponentialSequence) {
        this(l, d, d2);
    }

    public static class Builder {
        private long start = 1L;
        private double factor = 2.0;
        private double maxDeviation = 0.0;

        private Builder() {
        }

        public Builder start(int start) {
            Preconditions.checkArgument(start >= 0);
            this.start = start;
            return this;
        }

        public Builder factor(double factor) {
            Preconditions.checkArgument(factor >= 1.0);
            this.factor = factor;
            return this;
        }

        public Builder maxDeviation(double maxDeviation) {
            Preconditions.checkArgument(maxDeviation >= 0.0);
            this.maxDeviation = maxDeviation;
            return this;
        }

        public RandomExponentialSequence build() {
            return new RandomExponentialSequence(this.start, this.factor, this.maxDeviation, null);
        }
    }
}

