/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.stateguard;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.aopalliance.intercept.MethodInterceptor;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.GuardedInterceptor;
import org.sonatype.nexus.common.stateguard.SimpleMethodInvocation;
import org.sonatype.nexus.common.stateguard.Transitions;
import org.sonatype.nexus.common.stateguard.TransitionsInterceptor;

public class StateGuardAspect {
    static final MethodInterceptor GUARD = new GuardedInterceptor();
    static final MethodInterceptor TRANSITION = new TransitionsInterceptor();

    private StateGuardAspect() {
    }

    public static <S, T extends S> S around(final T instance) {
        final Class<?> impl = instance.getClass();
        return (S)Proxy.newProxyInstance(impl.getClassLoader(), impl.getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Method implMethod = impl.getMethod(method.getName(), method.getParameterTypes());
                boolean isGuarded = implMethod.isAnnotationPresent(Guarded.class);
                boolean isTransition = implMethod.isAnnotationPresent(Transitions.class);
                final SimpleMethodInvocation invocation = new SimpleMethodInvocation(instance, implMethod, args);
                if (isGuarded && isTransition) {
                    return GUARD.invoke(new SimpleMethodInvocation(instance, implMethod, args){

                        @Override
                        public Object proceed() throws Throwable {
                            return TRANSITION.invoke(invocation);
                        }
                    });
                }
                if (isGuarded) {
                    return GUARD.invoke(invocation);
                }
                if (isTransition) {
                    return TRANSITION.invoke(invocation);
                }
                return invocation.proceed();
            }
        });
    }
}

