/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.text;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public final class Plural {
    private Plural() {
    }

    public static StringBuilder append(StringBuilder buff, int value, String singular, @Nullable String plural) {
        Preconditions.checkNotNull(buff);
        Preconditions.checkNotNull(singular);
        buff.append(value).append(" ");
        if (value == 1) {
            buff.append(singular);
        } else if (plural == null) {
            buff.append(singular).append("s");
        } else {
            buff.append(plural);
        }
        return buff;
    }

    public static StringBuilder append(StringBuilder buff, int value, String singular) {
        return Plural.append(buff, value, singular, null);
    }

    public static String of(int value, String singular, @Nullable String plural) {
        return Plural.append(new StringBuilder(), value, singular, plural).toString();
    }

    public static String of(int value, String singular) {
        return Plural.of(value, singular, null);
    }
}

