/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.thread;

import com.google.common.base.Preconditions;

public final class TcclBlock
implements AutoCloseable {
    private final ClassLoader previous;

    private TcclBlock(ClassLoader previous) {
        this.previous = previous;
    }

    @Override
    public void close() {
        Thread.currentThread().setContextClassLoader(this.previous);
    }

    public static TcclBlock begin(ClassLoader classLoader) {
        Preconditions.checkNotNull(classLoader);
        Thread thread = Thread.currentThread();
        ClassLoader current = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        return new TcclBlock(current);
    }

    public static TcclBlock begin(Class<?> type) {
        Preconditions.checkNotNull(type);
        return TcclBlock.begin(type.getClassLoader());
    }

    public static TcclBlock begin(Object owner) {
        Preconditions.checkNotNull(owner);
        return TcclBlock.begin(owner.getClass().getClassLoader());
    }
}

