/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.common.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;

public class DateHelper {
    private DateHelper() {
    }

    @Nullable
    public static Date copy(@Nullable Date date) {
        if (date != null) {
            return new Date(date.getTime());
        }
        return null;
    }

    @Nullable
    public static DateTime toDateTime(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime(date.getTime());
    }

    @Nullable
    public static Date toDate(@Nullable DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toDate();
    }

    @Nullable
    public static Date toDate(@Nullable OffsetDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return new Date(dateTime.toInstant().toEpochMilli());
    }

    public static DateTime toDateTime(OffsetDateTime offsetDateTime) {
        return new DateTime(offsetDateTime.toInstant().toEpochMilli(), DateTimeZone.UTC);
    }

    public static OffsetDateTime toOffsetDateTime(DateTime dateTime) {
        return Instant.ofEpochMilli(dateTime.getMillis()).atOffset(ZoneOffset.UTC);
    }

    public static OffsetDateTime toOffsetDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atOffset(ZoneOffset.UTC);
    }

    public static java.time.Duration toJavaDuration(Duration jodaDuration) {
        return java.time.Duration.ofMillis(jodaDuration.getMillis());
    }

    public static Duration toJodaDuration(java.time.Duration javaDuration) {
        return Duration.millis(javaDuration.toMillis());
    }

    public static LocalDate toLocalDate(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        org.joda.time.LocalDate jodaDate = new org.joda.time.LocalDate(date);
        return LocalDate.of(jodaDate.getYear(), jodaDate.getMonthOfYear(), jodaDate.getDayOfMonth());
    }

    public static Date atStartOfDay(@Nullable LocalDate date) {
        if (date == null) {
            return null;
        }
        return Date.from(date.atStartOfDay(ZoneOffset.UTC).toInstant());
    }
}

