/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.distributed.event.service.api.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.sonatype.nexus.distributed.event.service.api.EventType;
import org.sonatype.nexus.distributed.event.service.api.common.DistributedEventSupport;

public class DataStoreConfigurationEvent
extends DistributedEventSupport {
    public static final String NAME = "DataStoreConfigurationEvent";
    private final String configurationName;
    private final String type;
    private final String source;
    private final Map<String, String> attributes;

    @JsonCreator
    public DataStoreConfigurationEvent(@JsonProperty(value="configurationName") String configurationName, @JsonProperty(value="type") String type, @JsonProperty(value="source") String source, @JsonProperty(value="attributes") Map<String, String> attributes) {
        super(EventType.UPDATED);
        this.configurationName = Preconditions.checkNotNull(configurationName);
        this.type = Preconditions.checkNotNull(type);
        this.source = Preconditions.checkNotNull(source);
        this.attributes = Preconditions.checkNotNull(attributes);
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public String getType() {
        return this.type;
    }

    public String getSource() {
        return this.source;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "DataStoreConfigurationEvent{name='" + this.configurationName + '\'' + ", type='" + this.type + '\'' + ", source='" + this.source + '\'' + ", attributes=" + this.attributes + '}';
    }
}

