/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.formfields;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.nexus.formfields.FormField;

public abstract class AbstractFormField<T>
implements FormField<T> {
    private String helpText;
    private String id;
    @Nullable
    private String regexValidation;
    private boolean required;
    private boolean disabled;
    private boolean readOnly;
    private String label;
    @Nullable
    private T initialValue;
    private Map<String, Object> attributes;

    public AbstractFormField(String id, String label, String helpText, boolean required, @Nullable String regexValidation, @Nullable T initialValue) {
        this(id, label, helpText, required, regexValidation);
        this.initialValue = initialValue;
    }

    public AbstractFormField(String id, String label, String helpText, boolean required, @Nullable String regexValidation) {
        this(id, label, helpText, required);
        this.regexValidation = regexValidation;
    }

    public AbstractFormField(String id, String label, String helpText, boolean required) {
        this(id);
        this.label = label;
        this.helpText = helpText;
        this.required = required;
    }

    public AbstractFormField(String id) {
        this.id = id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getRegexValidation() {
        return this.regexValidation;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    @Nullable
    public T getInitialValue() {
        return this.initialValue;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRegexValidation(@Nullable String regex) {
        this.regexValidation = regex;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setInitialValue(@Nullable T value) {
        this.initialValue = value;
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes;
    }

    public AbstractFormField<T> withAttribute(String key, Object value) {
        this.getAttributes().put(key, value);
        return this;
    }
}

