/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.formfields;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.sonatype.nexus.formfields.Combobox;

public class ComboboxFormField<V>
extends Combobox<V> {
    private String storeApi;
    private final Map<String, String> storeFilters = Maps.newHashMap();
    private String idMapping;
    private String nameMapping;

    public ComboboxFormField(String id, String label, String helpText, boolean required, V initialValue) {
        super(id, label, helpText, required, initialValue);
    }

    public ComboboxFormField(String id, String label, String helpText, boolean required) {
        this(id, label, helpText, required, null);
    }

    public ComboboxFormField(String id, String label, String helpText) {
        this(id, label, helpText, false);
    }

    public ComboboxFormField(String id, String label) {
        this(id, label, null);
    }

    @Override
    public String getStoreApi() {
        return this.storeApi;
    }

    @Override
    public Map<String, String> getStoreFilters() {
        return this.storeFilters.isEmpty() ? null : this.storeFilters;
    }

    @Override
    public String getIdMapping() {
        return this.idMapping;
    }

    @Override
    public String getNameMapping() {
        return this.nameMapping;
    }

    public ComboboxFormField<V> withStoreApi(String storeApi) {
        this.storeApi = Preconditions.checkNotNull(storeApi);
        return this;
    }

    public Combobox<V> withStoreFilter(String property, String value) {
        this.storeFilters.put(Preconditions.checkNotNull(property, "property"), Preconditions.checkNotNull(value, "value"));
        return this;
    }

    public ComboboxFormField<V> withIdMapping(String idMapping) {
        this.idMapping = idMapping;
        return this;
    }

    public ComboboxFormField<V> withNameMapping(String nameMapping) {
        this.nameMapping = nameMapping;
        return this;
    }
}

