/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.jmx.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.util.Hashtable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.EagerSingleton;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.jmx.MBean;
import org.sonatype.nexus.jmx.ObjectNameEntry;
import org.sonatype.nexus.jmx.reflect.ManagedObject;
import org.sonatype.nexus.jmx.reflect.ReflectionMBeanBuilder;

@Named
@EagerSingleton
public class ManagedObjectRegistrar
extends ComponentSupport {
    @Inject
    public ManagedObjectRegistrar(BeanLocator beanLocator, MBeanServer server) {
        Preconditions.checkNotNull(beanLocator);
        Preconditions.checkNotNull(server);
        beanLocator.watch(Key.get(Object.class), new ManageObjectMediator(), server);
    }

    @Nullable
    private ManagedObject descriptor(BeanEntry<Annotation, Object> entry) {
        Class<Object> type = entry.getImplementationClass();
        return type.getAnnotation(ManagedObject.class);
    }

    private ObjectName objectName(ManagedObject descriptor, BeanEntry<Annotation, Object> entry) throws Exception {
        Class<Object> type = entry.getImplementationClass();
        String domain = descriptor.domain();
        if (Strings.emptyToNull(domain) == null) {
            domain = type.getPackage().getName();
        }
        Hashtable<String, String> entries = new Hashtable<String, String>();
        ObjectNameEntry[] objectNameEntryArray = descriptor.entries();
        int n = objectNameEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectNameEntry kv = objectNameEntryArray[n2];
            entries.put(kv.name(), kv.value());
            ++n2;
        }
        entries.put("type", this.type(descriptor, entry));
        String name = this.name(descriptor, entry);
        if (name != null) {
            entries.put("name", name);
        }
        return new ObjectName(domain, entries);
    }

    private String type(ManagedObject descriptor, BeanEntry<Annotation, Object> entry) {
        String type = Strings.emptyToNull(descriptor.type());
        if (type == null) {
            type = descriptor.typeClass() != null && descriptor.typeClass() != Void.class ? descriptor.typeClass().getSimpleName() : entry.getImplementationClass().getSimpleName();
        }
        return type;
    }

    @Nullable
    private String name(ManagedObject descriptor, BeanEntry<Annotation, Object> entry) {
        String name = Strings.emptyToNull(descriptor.name());
        if (name == null) {
            Named named;
            Class<Object> type = entry.getImplementationClass();
            if (entry.getKey() instanceof Named) {
                named = (Named)entry.getKey();
                if (!type.getName().equals(named.value())) {
                    name = Strings.emptyToNull(named.value());
                }
            }
            if (name == null && (named = entry.getImplementationClass().getAnnotation(Named.class)) != null) {
                name = Strings.emptyToNull(named.value());
            }
        }
        return name;
    }

    private MBean mbean(ManagedObject descriptor, final BeanEntry<Annotation, Object> entry) throws Exception {
        Class<Object> type = entry.getImplementationClass();
        ReflectionMBeanBuilder builder = new ReflectionMBeanBuilder(type);
        builder.target(new Supplier<Object>(){

            @Override
            public Object get() {
                return entry.getProvider().get();
            }
        });
        String description = Strings.emptyToNull(descriptor.description());
        if (description == null) {
            description = entry.getDescription();
        }
        builder.description(description);
        builder.discover();
        return builder.build();
    }

    private class ManageObjectMediator
    implements Mediator<Annotation, Object, MBeanServer> {
        private ManageObjectMediator() {
        }

        @Override
        public void add(BeanEntry<Annotation, Object> entry, MBeanServer server) throws Exception {
            ManagedObject descriptor = ManagedObjectRegistrar.this.descriptor(entry);
            if (descriptor == null) {
                return;
            }
            try {
                ObjectName name = ManagedObjectRegistrar.this.objectName(descriptor, entry);
                ManagedObjectRegistrar.this.log.debug("Registering: {} -> {}", (Object)name, (Object)entry);
                MBean mbean = ManagedObjectRegistrar.this.mbean(descriptor, entry);
                server.registerMBean(mbean, name);
            }
            catch (Exception e) {
                ManagedObjectRegistrar.this.log.warn("Failed to export: {}; ignoring", (Object)entry, (Object)e);
            }
        }

        @Override
        public void remove(BeanEntry<Annotation, Object> entry, MBeanServer server) throws Exception {
            ManagedObject descriptor = ManagedObjectRegistrar.this.descriptor(entry);
            if (descriptor == null) {
                return;
            }
            try {
                ObjectName name = ManagedObjectRegistrar.this.objectName(descriptor, entry);
                ManagedObjectRegistrar.this.log.debug("Un-registering: {} -> {}", (Object)name, (Object)entry);
                server.unregisterMBean(name);
            }
            catch (Exception e) {
                ManagedObjectRegistrar.this.log.warn("Failed to un-export: {}; ignoring", (Object)entry, (Object)e);
            }
        }
    }
}

