/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.logging.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.sonatype.nexus.logging.task.TaskLoggerHelper;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

public class ProgressLogIntervalHelper
implements AutoCloseable {
    private final Stopwatch elapsed;
    private final Stopwatch progress;
    private final Logger logger;
    private final int internal;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;

    public ProgressLogIntervalHelper(Logger logger, int intervalInSeconds) {
        this.logger = Preconditions.checkNotNull(logger);
        this.internal = intervalInSeconds;
        this.elapsed = Stopwatch.createStarted();
        this.progress = Stopwatch.createStarted();
    }

    public String getElapsed() {
        return this.formatDuration(this.elapsed.elapsed().getSeconds());
    }

    private String formatDuration(long durationSeconds) {
        StringBuilder builder = new StringBuilder();
        long seconds = durationSeconds;
        long days = seconds / 86400L;
        seconds -= days * 86400L;
        if (days > 0L) {
            builder.append(days).append("d ");
        }
        long hours = seconds / 3600L;
        seconds -= hours * 3600L;
        if (hours > 0L || builder.length() > 0) {
            builder.append(hours).append("h ");
        }
        long minutes = seconds / 60L;
        seconds -= minutes * 60L;
        if (minutes > 0L || builder.length() > 0) {
            builder.append(minutes).append("m ");
        }
        builder.append(seconds).append("s");
        return builder.toString();
    }

    public void info(String message, Object ... args) {
        if (this.hasIntervalElapsed()) {
            this.logger.info(TaskLoggingMarkers.PROGRESS, message, args);
        } else {
            TaskLoggerHelper.progress(this.logger, message, args);
        }
    }

    public void flush() {
        TaskLoggerHelper.flush();
    }

    private boolean hasIntervalElapsed() {
        boolean logProgress;
        boolean bl = logProgress = this.progress.elapsed(TimeUnit.SECONDS) >= (long)this.internal;
        if (logProgress) {
            this.progress.reset().start();
        }
        return logProgress;
    }

    @Override
    public void close() {
        this.flush();
    }
}

