/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.logging.task;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.sonatype.nexus.logging.task.TaskLogger;
import org.sonatype.nexus.logging.task.TaskLoggingEvent;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

public class ProgressTaskLogger
implements TaskLogger {
    static final String PROGRESS_LINE = "---- %s ----";
    private static final long INTERVAL_MINUTES = 10L;
    private static final ScheduledExecutorService executorService = ProgressTaskLogger.createExecutorService();
    protected final Logger log;
    private Future<?> progressLoggingThread;
    private Map<String, String> mdcMap;
    private final long initialDelay;
    private final long progressInterval;
    private final TimeUnit timeUnit;
    TaskLoggingEvent lastProgressEvent;

    ProgressTaskLogger(Logger log) {
        this(log, 10L, 10L, TimeUnit.MINUTES);
    }

    ProgressTaskLogger(Logger log, long initialDelay, long progressInterval, TimeUnit timeUnit) {
        this.log = Preconditions.checkNotNull(log);
        this.initialDelay = initialDelay;
        Preconditions.checkArgument(progressInterval > 0L, "progressInterval must be greater than 0");
        this.progressInterval = progressInterval;
        this.timeUnit = Preconditions.checkNotNull(timeUnit);
    }

    @Override
    public void start() {
        this.mdcMap = MDC.getCopyOfContextMap();
        this.startProgressThread();
    }

    @Override
    public void finish() {
        this.progressLoggingThread.cancel(true);
    }

    @Override
    public void progress(TaskLoggingEvent event) {
        this.lastProgressEvent = event;
    }

    @Override
    public void flush() {
        this.logProgress();
    }

    public static void shutdown() {
        executorService.shutdown();
    }

    @VisibleForTesting
    void logProgress() {
        if (this.lastProgressEvent != null) {
            if (this.mdcMap != null) {
                MDC.setContextMap(this.mdcMap);
            }
            Logger logger = Optional.ofNullable(this.lastProgressEvent.getLogger()).orElse(this.log);
            logger.info(TaskLoggingMarkers.INTERNAL_PROGRESS, String.format(PROGRESS_LINE, this.lastProgressEvent.getMessage()), this.lastProgressEvent.getArgumentArray());
            this.lastProgressEvent = null;
        }
    }

    private static ScheduledExecutorService createExecutorService() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("task-logging-%d").build());
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    private void startProgressThread() {
        this.progressLoggingThread = executorService.scheduleAtFixedRate(this::logProgress, this.initialDelay, this.progressInterval, this.timeUnit);
    }
}

