/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.storage.OStorage;
import org.sonatype.nexus.orient.DatabasePoolSupport;

public class DatabasePoolImpl
extends DatabasePoolSupport {
    private final OPartitionedDatabasePool delegate;

    public DatabasePoolImpl(OPartitionedDatabasePool delegate, String name) {
        super(name);
        this.delegate = Preconditions.checkNotNull(delegate);
    }

    @Override
    protected void doStop() throws Exception {
        this.delegate.close();
    }

    @Override
    public ODatabaseDocumentTx acquire() {
        this.ensureStarted();
        return this.delegate.acquire();
    }

    @Override
    public int getAvailableCount() {
        return this.delegate.getAvailableConnections();
    }

    @Override
    public int getPoolSize() {
        return this.delegate.getCreatedInstances();
    }

    @Override
    public void replaceStorage(OStorage storage) {
        this.replaceStorage(this.delegate, storage);
    }
}

