/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Provider;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.upgrade.Upgrade;
import org.sonatype.nexus.orient.DatabaseInstance;

public abstract class DatabaseUpgradeSupport
extends ComponentSupport
implements Upgrade {
    protected static boolean hasSchemaClass(Provider<DatabaseInstance> databaseInstance, String className) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = databaseInstance.get().connect();){
            return db.getMetadata().getSchema().existsClass(className);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static void withDatabaseAndClass(Provider<DatabaseInstance> databaseInstance, String className, BiConsumer<ODatabaseDocumentTx, OClass> consumer) {
        DatabaseUpgradeSupport.withDatabase(databaseInstance, db -> {
            if (db.getMetadata().getSchema().existsClass(className)) {
                consumer.accept((ODatabaseDocumentTx)db, db.getMetadata().getSchema().getClass(className));
            }
        });
    }

    protected static void withDatabase(Provider<DatabaseInstance> databaseInstance, Consumer<ODatabaseDocumentTx> consumer) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = databaseInstance.get().connect();){
            consumer.accept(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

