/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.primitives.Ints;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.orient.RecordIdObfuscator;

public abstract class RecordIdObfuscatorSupport
extends ComponentSupport
implements RecordIdObfuscator {
    @Override
    public String encode(OClass type, ORID rid) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(rid);
        this.log.trace("Encoding: {}->{}", (Object)type, (Object)rid);
        try {
            return this.doEncode(type, rid);
        }
        catch (Exception e) {
            this.log.error("Failed to encode: {}->{}", (Object)type, (Object)rid);
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    protected abstract String doEncode(OClass var1, ORID var2) throws Exception;

    @Override
    public ORID decode(OClass type, String encoded) {
        ORID rid;
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(encoded);
        this.log.trace("Decoding: {}->{}", (Object)type, (Object)encoded);
        try {
            rid = this.doDecode(type, encoded);
        }
        catch (Exception e) {
            this.log.error("Failed to decode: {}->{}", (Object)type, (Object)encoded);
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
        Preconditions.checkArgument(Ints.contains(type.getClusterIds(), rid.getClusterId()), "Invalid RID '%s' for class: %s", (Object)rid, (Object)type);
        return rid;
    }

    protected abstract ORID doDecode(OClass var1, String var2) throws Exception;
}

