/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.id.ORID;
import javax.annotation.Nonnull;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.orient.entity.EntityAdapter;

public class AttachedEntityId
implements EntityId {
    private final EntityAdapter<?> owner;
    private final ORID identity;
    private volatile String encoded;

    public AttachedEntityId(EntityAdapter<?> owner, ORID identity) {
        this.owner = Preconditions.checkNotNull(owner);
        this.identity = Preconditions.checkNotNull(identity);
    }

    public ORID getIdentity() {
        return this.identity;
    }

    @Override
    @Nonnull
    public String getValue() {
        if (this.encoded == null) {
            Preconditions.checkState(!this.identity.isTemporary(), "attempted use of temporary/uncommitted document id");
            this.encoded = this.owner.getRecordIdObfuscator().encode(this.owner.getSchemaType(), this.identity);
        }
        return this.encoded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AttachedEntityId) {
            AttachedEntityId that = (AttachedEntityId)o;
            return this.identity.equals(that.identity);
        }
        if (o instanceof EntityId) {
            EntityId that = (EntityId)o;
            return this.getValue().equals(that.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '{' + this.owner.getSchemaType() + "->" + this.identity + '}';
    }
}

