/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.DetachedEntityMetadata;
import org.sonatype.nexus.common.entity.DetachedEntityVersion;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.common.entity.EntityVersion;
import org.sonatype.nexus.orient.entity.AttachedEntityId;
import org.sonatype.nexus.orient.entity.AttachedEntityVersion;
import org.sonatype.nexus.orient.entity.EntityAdapter;

public class AttachedEntityMetadata
implements EntityMetadata {
    private final EntityAdapter owner;
    private final ODocument document;
    private final EntityId id;
    private final EntityVersion version;

    public AttachedEntityMetadata(EntityAdapter owner, ODocument document) {
        this.owner = Preconditions.checkNotNull(owner);
        this.document = Preconditions.checkNotNull(document);
        this.id = new AttachedEntityId(owner, document.getIdentity());
        this.version = new AttachedEntityVersion(owner, document.getVersion());
    }

    public EntityAdapter getOwner() {
        return this.owner;
    }

    public ODocument getDocument() {
        return this.document;
    }

    @Override
    @Nonnull
    public EntityId getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public EntityVersion getVersion() {
        return this.version;
    }

    public DetachedEntityMetadata detach() {
        return new DetachedEntityMetadata(new DetachedEntityId(this.id.getValue()), new DetachedEntityVersion(this.version.getValue()));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "schema=" + this.owner.getTypeName() + ", document=" + this.safeDocumentToString() + '}';
    }

    private String safeDocumentToString() {
        ORecordElement.STATUS oldStatus = this.document.getInternalStatus();
        try {
            this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            String string = this.document.toString();
            return string;
        }
        catch (Exception exception) {
            String string = this.document.getIdentity().toString();
            return string;
        }
        finally {
            this.document.setInternalStatus(oldStatus);
        }
    }

    @Override
    public <T> Optional<Class<T>> getEntityType() {
        return Optional.of(this.getOwner().getEntityType());
    }

    @Override
    public <T extends Entity> Optional<T> getEntity() {
        Object newEntity = this.getOwner().newEntity();
        newEntity.setEntityMetadata(this);
        try {
            this.getOwner().readFields(this.getDocument(), newEntity);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
        return Optional.of(newEntity);
    }
}

