/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.reflect.TypeToken;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.DetachingList;
import org.sonatype.nexus.common.collect.DetachingMap;
import org.sonatype.nexus.common.collect.DetachingSet;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityCreatedEvent;
import org.sonatype.nexus.common.entity.EntityDeletedEvent;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.common.entity.EntityUpdatedEvent;
import org.sonatype.nexus.orient.RecordIdObfuscator;
import org.sonatype.nexus.orient.entity.AttachedEntityId;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.ConflictHook;
import org.sonatype.nexus.orient.entity.ConflictState;
import org.sonatype.nexus.orient.entity.DeconflictStep;
import org.sonatype.nexus.orient.entity.EntityHook;

public abstract class EntityAdapter<T extends Entity>
extends ComponentSupport {
    private final String typeName;
    private final Class<T> entityType;
    private RecordIdObfuscator recordIdObfuscator;
    private EntityHook entityHook;
    private ConflictHook conflictHook;
    private List<? extends DeconflictStep<T>> deconflictSteps = ImmutableList.of();
    private String dbName;
    private OClass schemaType;
    private boolean partialLoading;

    public EntityAdapter(String typeName) {
        this.typeName = Preconditions.checkNotNull(typeName);
        TypeToken<EntityAdapter> superType = TypeToken.of(this.getClass()).getSupertype(EntityAdapter.class);
        this.entityType = (Class)((ParameterizedType)superType.getType()).getActualTypeArguments()[0];
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    @Inject
    public void enableObfuscation(RecordIdObfuscator recordIdObfuscator) {
        this.recordIdObfuscator = Preconditions.checkNotNull(recordIdObfuscator);
    }

    @Inject
    public void enableEntityHook(EntityHook entityHook) {
        this.entityHook = Preconditions.checkNotNull(entityHook);
    }

    @Inject
    public void enableConflictHook(ConflictHook conflictHook) {
        this.conflictHook = Preconditions.checkNotNull(conflictHook);
    }

    @Inject
    public void setDeconflictSteps(List<? extends DeconflictStep<T>> deconflictSteps) {
        this.deconflictSteps = Preconditions.checkNotNull(deconflictSteps);
    }

    protected void enablePartialLoading() {
        this.partialLoading = true;
    }

    protected RecordIdObfuscator getRecordIdObfuscator() {
        Preconditions.checkState(this.recordIdObfuscator != null);
        return this.recordIdObfuscator;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "typeName='" + this.typeName + '\'' + '}';
    }

    public void register(ODatabaseDocumentTx db, @Nullable Runnable initializer) {
        Preconditions.checkNotNull(db);
        OSchemaProxy schema = db.getMetadata().getSchema();
        OClass type = schema.getClass(this.typeName);
        if (type == null) {
            int clusters = this.getMinimumClusters();
            type = clusters > 0 ? schema.createClass(this.typeName, clusters, new OClass[0]) : schema.createClass(this.typeName);
            this.defineType(db, type);
            this.log.debug("Created schema type '{}': properties={}, indexes={}", type, type.properties(), type.getIndexes());
            if (initializer != null) {
                this.log.debug("Running initializer: {}", (Object)initializer);
                initializer.run();
            }
        }
        this.dbName = db.getName();
        this.schemaType = type;
        if (this.sendEvents() && this.entityHook != null) {
            this.entityHook.enableEvents(this);
        }
        if (this.resolveConflicts() && this.conflictHook != null) {
            this.conflictHook.enableConflictResolution(this);
            if (!this.conflictHook.equals(db.getConflictStrategy())) {
                db.setConflictStrategy(this.conflictHook);
            }
        }
    }

    public void register(ODatabaseDocumentTx db) {
        this.register(db, null);
    }

    protected int getMinimumClusters() {
        return 0;
    }

    protected void defineType(ODatabaseDocumentTx db, OClass type) {
        this.defineType(type);
    }

    protected abstract void defineType(OClass var1);

    protected void enableRecordEncryption(ODatabaseDocumentTx db, OClass type) {
        OStorage storage = db.getStorage();
        int[] nArray = type.getClusterIds();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int clusterId = nArray[n2];
            OCluster cluster = storage.getClusterById(clusterId);
            try {
                this.log.debug("Enabling PBE compression for cluster: {}", (Object)cluster.getName());
                cluster.set(OCluster.ATTRIBUTES.COMPRESSION, "pbe");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (OSecurityException | OStorageException | IllegalArgumentException e) {
                this.log.warn("Cannot enable PBE compression for cluster: {}", (Object)cluster.getName(), (Object)e);
            }
            ++n2;
        }
    }

    public String getDbName() {
        Preconditions.checkState(this.dbName != null, "Not registered");
        return this.dbName;
    }

    public OClass getSchemaType() {
        Preconditions.checkState(this.schemaType != null, "Not registered");
        return this.schemaType;
    }

    protected abstract T newEntity();

    protected abstract void readFields(ODocument var1, T var2) throws Exception;

    protected abstract void writeFields(ODocument var1, T var2) throws Exception;

    public Iterable<ODocument> browseDocuments(ODatabaseDocumentTx db) {
        Preconditions.checkNotNull(db);
        return db.browseClass(this.typeName);
    }

    public T readEntity(OIdentifiable identifiable) {
        ODocument document = (ODocument)identifiable.getRecord();
        Preconditions.checkNotNull(document);
        T entity = this.newEntity();
        if (!this.partialLoading) {
            document.deserializeFields(new String[0]);
        }
        try {
            this.readFields(document, entity);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
        this.attachMetadata(entity, document);
        return entity;
    }

    public ODocument writeEntity(ODocument document, T entity) {
        Preconditions.checkNotNull(document);
        Preconditions.checkNotNull(entity);
        try {
            this.writeFields(document, entity);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
        this.attachMetadata(entity, document);
        return document.save();
    }

    public ODocument editEntity(ODatabaseDocumentTx db, T entity) {
        Preconditions.checkNotNull(db);
        Preconditions.checkNotNull(entity);
        ORID rid = this.recordIdentity(entity);
        ODocument document = (ODocument)db.getRecord(rid);
        Preconditions.checkState(document != null);
        return this.writeEntity(document, entity);
    }

    public ODocument addEntity(ODatabaseDocumentTx db, T entity) {
        Preconditions.checkNotNull(db);
        Preconditions.checkNotNull(entity);
        EntityMetadata metadata = entity.getEntityMetadata();
        Preconditions.checkState(metadata == null || this.recordIdentity(metadata.getId()).isNew());
        ODocument doc = db.newInstance(this.typeName);
        return this.writeEntity(doc, entity);
    }

    public void deleteEntity(ODatabaseDocumentTx db, T entity) {
        Preconditions.checkNotNull(db);
        Preconditions.checkNotNull(entity);
        ORID rid = this.recordIdentity(entity);
        db.delete(rid);
        entity.setEntityMetadata(null);
    }

    protected void attachMetadata(T entity, ODocument doc) {
        entity.setEntityMetadata(new AttachedEntityMetadata(this, doc));
    }

    public ODocument document(ODatabaseDocumentTx db, EntityId id) {
        ORID rid = id instanceof AttachedEntityId ? ((AttachedEntityId)id).getIdentity() : this.getRecordIdObfuscator().decode(this.getSchemaType(), id.getValue());
        return (ODocument)db.getRecord(rid);
    }

    public Iterable<ODocument> documents(ODatabaseDocumentTx db, Iterable<EntityId> ids) {
        Set rids = Streams.stream(ids).map(id -> {
            if (id instanceof AttachedEntityId) {
                return ((AttachedEntityId)id).getIdentity();
            }
            return this.getRecordIdObfuscator().decode(this.getSchemaType(), id.getValue());
        }).collect(Collectors.toSet());
        return (Iterable)db.command(new OCommandSQL("select from :rids")).execute(Collections.singletonMap("rids", rids));
    }

    public ORID recordIdentity(T entity) {
        return this.recordIdentity(EntityHelper.id(entity));
    }

    public ORID recordIdentity(EntityId id) {
        Preconditions.checkNotNull(id);
        if (id instanceof AttachedEntityId) {
            return ((AttachedEntityId)id).getIdentity();
        }
        return this.getRecordIdObfuscator().decode(this.getSchemaType(), id.getValue());
    }

    protected <K, V> Map<K, V> detachable(Map<K, V> attributes) {
        return new DetachingMap<K, Object>(attributes, this::allowDetach, this::detach);
    }

    private boolean allowDetach() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        return db == null || !this.getDbName().equals(db.getName());
    }

    protected <V> V detach(V value) {
        Object untracked = value;
        if (value instanceof OTrackedMap) {
            untracked = new DetachingMap((Map)value, this::allowDetach, this::detach);
        } else if (value instanceof OTrackedList) {
            untracked = new DetachingList<Object>((List)value, this::allowDetach, this::detach);
        } else if (value instanceof OTrackedSet) {
            untracked = new DetachingSet<Object>((Set)value, this::allowDetach, this::detach);
        }
        return untracked;
    }

    public boolean sendEvents() {
        return false;
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata(this, document);
        switch (eventKind) {
            case CREATE: {
                return new EntityCreatedEvent(metadata);
            }
            case UPDATE: {
                return new EntityUpdatedEvent(metadata);
            }
            case DELETE: {
                return new EntityDeletedEvent(metadata);
            }
        }
        return null;
    }

    public String eventAffinity(ODocument document) {
        return document.getIdentity().toString();
    }

    public boolean resolveConflicts() {
        return false;
    }

    public ConflictState resolve(ODocument storedRecord, ODocument changeRecord) {
        return this.deconflictSteps.stream().reduce(ConflictState.IGNORE, (decision, step) -> decision.andThen(() -> step.deconflict(storedRecord, changeRecord)), ConflictState::max).andThen(() -> this.compare(storedRecord, changeRecord));
    }

    protected ConflictState compare(ODocument storedRecord, ODocument changeRecord) {
        for (Map.Entry<String, Object> property : storedRecord) {
            Object changeValue = changeRecord.rawField(property.getKey());
            if (Objects.equals(property.getValue(), changeValue)) continue;
            this.log.trace("Conflict detected in {}: {} vs {}", property.getKey(), property.getValue(), changeValue);
            return ConflictState.DENY;
        }
        return ConflictState.IGNORE;
    }

    public static enum EventKind {
        CREATE,
        UPDATE,
        DELETE;

    }
}

