/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.security.OSecurityNull;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.entity.EntityBatchEvent;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.orient.entity.DatabaseListenerSupport;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.SingletonEntityAdapter;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public final class EntityHook
extends DatabaseListenerSupport {
    private static final Logger log = LoggerFactory.getLogger(EntityHook.class);
    private static final ThreadLocal<String> isRemote = new ThreadLocal();
    private static final ThreadLocal<ODatabase> commitDb = new ThreadLocal();
    private final Map<String, EntityAdapter<?>> recordingAdapters = new ConcurrentHashMap();
    private final Set<String> recordingDatabases = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<ODatabase, List<Object>> dbEvents = new ConcurrentHashMap<ODatabase, List<Object>>();
    private final List<ODatabase> pendingDbs = Collections.synchronizedList(new ArrayList());
    private final EventManager eventManager;

    @Inject
    public EntityHook(EventManager eventManager) {
        this.eventManager = Preconditions.checkNotNull(eventManager);
    }

    public static <T> T asRemote(String remoteNodeId, Supplier<T> supplier) {
        isRemote.set(remoteNodeId);
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            isRemote.remove();
        }
    }

    public static void asRemote(String remoteNodeId, Runnable runnable) {
        isRemote.set(remoteNodeId);
        try {
            runnable.run();
        }
        finally {
            isRemote.remove();
        }
    }

    public void enableEvents(EntityAdapter adapter) {
        log.trace("Enable entity events for {}", (Object)adapter);
        this.recordingAdapters.put(adapter.getTypeName(), adapter);
        this.recordingDatabases.add(adapter.getDbName());
        this.pendingDbs.removeIf(db -> db.isClosed() || this.startRecording((ODatabase)db));
    }

    public void disableEvents(EntityAdapter adapter) {
        log.trace("Disable entity events for {}", (Object)adapter);
        this.recordingAdapters.remove(adapter.getTypeName());
    }

    @Override
    public void onOpen(ODatabaseInternal db) {
        this.unregisterLiveQueryHook(db);
        if (OSecurityNull.class.equals(db.getProperty(ODatabase.OPTIONS.SECURITY.toString()))) {
            return;
        }
        if (!this.startRecording(db)) {
            this.pendingDbs.add(db);
        }
        if (db.getMetadata().getSchema().countClasses() == 0) {
            log.debug("Reloading metadata for {} as storage has changed", (Object)db.getName());
            db.getMetadata().reload();
        }
    }

    @Override
    public void onClose(ODatabaseInternal db) {
        if (!this.pendingDbs.remove(db)) {
            this.stopRecording(db);
            this.flushEvents(db);
        }
    }

    @Override
    public ORecordHook.RESULT onTrigger(ORecordHook.TYPE type, ORecord record) {
        EntityAdapter.EventKind eventKind = EntityHook.getEventKind(type);
        if (eventKind != null && record instanceof ODocument && this.recordEvent((ODocument)record, eventKind)) {
            log.trace("Recorded {} {}", (Object)type, (Object)record);
        } else {
            log.trace("Ignored {} {}", (Object)type, (Object)record);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onBeforeTxCommit(ODatabase db) {
        commitDb.set(db);
    }

    @Override
    public void onAfterTxCommit(ODatabase db) {
        commitDb.remove();
        this.flushEvents(db);
    }

    @Override
    public void onAfterTxRollback(ODatabase db) {
        commitDb.remove();
        this.dbEvents.remove(db);
    }

    private boolean startRecording(ODatabase db) {
        if (this.recordingDatabases.contains(db.getName())) {
            db.registerListener(this);
            EntityHook.withActiveDb(db, () -> db.registerHook(this, ORecordHook.HOOK_POSITION.LAST));
            return true;
        }
        return false;
    }

    private void stopRecording(ODatabase db) {
        db.unregisterHook(this);
        db.unregisterListener(this);
    }

    private static <T> T withActiveDb(ODatabase db, Supplier<T> supplier) {
        ODatabaseDocumentInternal currentDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db.equals(currentDb) || !(db instanceof ODatabaseDocumentInternal)) {
            return supplier.get();
        }
        try {
            ODatabaseRecordThreadLocal.instance().set((ODatabaseDocumentInternal)db);
            T t2 = supplier.get();
            return t2;
        }
        finally {
            if (currentDb != null) {
                ODatabaseRecordThreadLocal.instance().set(currentDb);
            } else {
                ODatabaseRecordThreadLocal.instance().remove();
            }
        }
    }

    private boolean recordEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        ODatabaseDocumentInternal db;
        EntityAdapter<?> adapter;
        String typeName = document.getClassName();
        if (typeName != null && (adapter = this.recordingAdapters.get(typeName)) != null && (db = this.getCurrrentDb()) != null) {
            List<Object> events;
            if (db.getStorage().isDistributed() && adapter instanceof SingletonEntityAdapter) {
                ((SingletonEntityAdapter)adapter).singleton.replicate(document, eventKind);
            }
            if ((events = this.dbEvents.get(db)) == null) {
                events = new ArrayList<Object>();
                this.dbEvents.put(db, events);
            }
            EntityHook.upsertEvent(events, document, eventKind);
            return true;
        }
        return false;
    }

    private ODatabaseDocumentInternal getCurrrentDb() {
        ODatabase db = commitDb.get();
        if (db == null) {
            db = ODatabaseRecordThreadLocal.instance().get();
        }
        return (ODatabaseDocumentInternal)db;
    }

    private static void upsertEvent(List<Object> events, ODocument document, EntityAdapter.EventKind eventKind) {
        int i = 0;
        while (i < events.size()) {
            if (document.equals(events.get(i))) {
                if (eventKind == EntityAdapter.EventKind.DELETE && events.set(i + 1, (Object)EntityAdapter.EventKind.DELETE) == EntityAdapter.EventKind.CREATE) {
                    events.remove(i);
                    events.remove(i);
                } else {
                    events.set(i, document);
                }
                return;
            }
            i += 2;
        }
        events.add(document);
        events.add((Object)eventKind);
    }

    private void flushEvents(ODatabase db) {
        block7: {
            List<Object> events = this.dbEvents.remove(db);
            if (events != null) {
                UnitOfWork work = UnitOfWork.pause();
                String remoteNodeId = isRemote.get();
                try {
                    try {
                        if (remoteNodeId == null) {
                            this.postEvents(db, events, null);
                            break block7;
                        }
                        EventHelper.asReplicating(() -> this.postEvents(db, events, remoteNodeId));
                    }
                    catch (Throwable e) {
                        log.error("Failed to post entity events", e);
                        UnitOfWork.resume((UnitOfWork)work);
                    }
                }
                finally {
                    UnitOfWork.resume((UnitOfWork)work);
                }
            }
        }
    }

    private void postEvents(ODatabase db, List<Object> events, String remoteNodeId) {
        ArrayList<EntityEvent> batchedEvents = new ArrayList<EntityEvent>();
        int i = 0;
        while (i < events.size()) {
            EntityEvent event = this.newEntityEvent((ODocument)events.get(i), (EntityAdapter.EventKind)((Object)events.get(i + 1)));
            if (event != null) {
                event.setRemoteNodeId(remoteNodeId);
                this.eventManager.post(event);
                db.activateOnCurrentThread();
                if (event instanceof EntityBatchEvent.Batchable) {
                    batchedEvents.add(event);
                }
            }
            i += 2;
        }
        if (!batchedEvents.isEmpty()) {
            this.eventManager.post(new EntityBatchEvent(batchedEvents));
            db.activateOnCurrentThread();
        }
    }

    @Nullable
    private EntityEvent newEntityEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        EntityAdapter<?> adapter = this.recordingAdapters.get(document.getClassName());
        EntityEvent event = adapter.newEvent(document, eventKind);
        if (event != null && this.eventManager.isAffinityEnabled()) {
            event.setAffinity(adapter.eventAffinity(document));
        }
        return event;
    }

    @Nullable
    private static EntityAdapter.EventKind getEventKind(ORecordHook.TYPE type) {
        switch (type) {
            case AFTER_CREATE: {
                return EntityAdapter.EventKind.CREATE;
            }
            case AFTER_UPDATE: {
                return EntityAdapter.EventKind.UPDATE;
            }
            case AFTER_DELETE: {
                return EntityAdapter.EventKind.DELETE;
            }
        }
        return null;
    }

    private void unregisterLiveQueryHook(ODatabase db) {
        Optional<Object> liveQueryHook = db.getHooks().keySet().stream().filter(hook -> hook instanceof OLiveQueryHook).findFirst();
        if (liveQueryHook.isPresent()) {
            log.debug("Unregistering OLiveQueryHook");
            db.unregisterListener((ODatabaseListener)liveQueryHook.get());
            db.unregisterHook((ORecordHook)liveQueryHook.get());
        }
    }
}

