/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity.action;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.QueryUtils;

public class BrowseEntitiesByPropertyAction<T extends Entity>
extends ComponentSupport {
    private final IterableEntityAdapter<T> adapter;
    private final String query;

    public BrowseEntitiesByPropertyAction(IterableEntityAdapter<T> adapter, String ... properties) {
        this.adapter = Preconditions.checkNotNull(adapter);
        this.query = String.format("SELECT FROM %s WHERE %s", adapter.getTypeName(), QueryUtils.buildPredicate(properties));
    }

    public Iterable<T> execute(ODatabaseDocumentTx db, Object ... values) {
        Preconditions.checkNotNull(db);
        Preconditions.checkArgument(values.length > 0);
        Iterable results = (Iterable)db.command(new OSQLSynchQuery(this.query)).execute(values);
        return this.adapter.transform(results);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "query='" + this.query + '\'' + '}';
    }
}

