/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity.action;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.action.QueryUtils;

public class DeleteEntityByPropertyAction
extends ComponentSupport {
    private final String query;

    public DeleteEntityByPropertyAction(EntityAdapter<?> adapter, String ... properties) {
        Preconditions.checkNotNull(adapter);
        this.query = String.format("DELETE FROM %s WHERE %s", adapter.getTypeName(), QueryUtils.buildPredicate(properties));
    }

    public boolean execute(ODatabaseDocumentTx db, Object ... values) {
        Preconditions.checkNotNull(db);
        Preconditions.checkArgument(values.length > 0);
        int records = (Integer)db.command(new OCommandSQL(this.query)).execute(values);
        return records == 1;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "query='" + this.query + '\'' + '}';
    }
}

