/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity.action;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.action.QueryUtils;

public class ReadEntitiesByPropertyAction<T extends Entity>
extends ComponentSupport {
    private final EntityAdapter<T> adapter;
    private final String query;

    public ReadEntitiesByPropertyAction(EntityAdapter<T> adapter, String property) {
        this.adapter = Preconditions.checkNotNull(adapter);
        this.query = String.format("SELECT FROM %s WHERE %s IN", adapter.getTypeName(), property);
    }

    @Nullable
    public List<T> execute(ODatabaseDocumentTx db, Set<?> values) {
        Preconditions.checkNotNull(db);
        Preconditions.checkArgument(!values.isEmpty());
        String q = String.valueOf(this.query) + QueryUtils.buildIn(values);
        List results = (List)db.command(new OSQLSynchQuery(q)).execute(values);
        return Lists.newArrayList(results.stream().map(this.adapter::readEntity).collect(Collectors.toList()));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "query='" + this.query + '\'' + '}';
    }
}

