/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.freeze;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class FreezeRequest {
    private final InitiatorType initiatorType;
    private final String initiatorId;
    private final DateTime timestamp;
    private String nodeId;

    public FreezeRequest(InitiatorType initiatorType, String initiatorId) {
        this(initiatorType, initiatorId, DateTime.now(DateTimeZone.UTC));
    }

    @JsonCreator
    public FreezeRequest(@JsonProperty(value="initiatorType") InitiatorType initiatorType, @JsonProperty(value="initiatorId") String initiatorId, @JsonProperty(value="timestamp") DateTime timestamp) {
        this.initiatorType = Preconditions.checkNotNull(initiatorType);
        this.initiatorId = Preconditions.checkNotNull(initiatorId);
        this.timestamp = Preconditions.checkNotNull(timestamp);
    }

    public InitiatorType getInitiatorType() {
        return this.initiatorType;
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public String getNodeId() {
        return this.nodeId;
    }

    @JsonProperty(value="nodeId")
    public FreezeRequest setNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public String toString() {
        return "FreezeRequest{initiatorType=" + (Object)((Object)this.initiatorType) + ", initiatorId='" + this.initiatorId + '\'' + ", timestamp=" + this.timestamp + ", nodeId='" + this.nodeId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FreezeRequest request = (FreezeRequest)o;
        if (this.initiatorType != request.initiatorType) {
            return false;
        }
        if (!this.initiatorId.equals(request.initiatorId)) {
            return false;
        }
        if (!this.timestamp.equals(request.timestamp)) {
            return false;
        }
        return this.nodeId != null ? this.nodeId.equals(request.nodeId) : request.nodeId == null;
    }

    public int hashCode() {
        int result = this.initiatorType.hashCode();
        result = 31 * result + this.initiatorId.hashCode();
        result = 31 * result + this.timestamp.hashCode();
        result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        return result;
    }

    public static enum InitiatorType {
        SYSTEM,
        USER_INITIATED;

    }
}

