/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.internal;

import com.orientechnologies.orient.core.compression.OCompression;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.crypto.PbeCipherFactory;

@Singleton
@Named(value="pbe")
public class PbeCompression
implements OCompression {
    public static final String NAME = "pbe";
    private static final String CPREFIX = "${nexus.orient.pbe";
    private final PbeCipherFactory.PbeCipher pbeCipher;

    @Inject
    public PbeCompression(PbeCipherFactory pbeCipherFactory, @Named(value="${nexus.orient.pbe.password:-changeme}") @Named(value="${nexus.orient.pbe.password:-changeme}") String password, @Named(value="${nexus.orient.pbe.salt:-changeme}") @Named(value="${nexus.orient.pbe.salt:-changeme}") String salt, @Named(value="${nexus.orient.pbe.iv:-0123456789ABCDEF}") @Named(value="${nexus.orient.pbe.iv:-0123456789ABCDEF}") String iv) throws Exception {
        this.pbeCipher = pbeCipherFactory.create(password, salt, iv);
    }

    @Override
    public byte[] compress(byte[] bytes) {
        return this.pbeCipher.encrypt(bytes);
    }

    @Override
    public byte[] uncompress(byte[] bytes) {
        return this.pbeCipher.decrypt(bytes);
    }

    @Override
    public byte[] compress(byte[] bytes, int offset, int length) {
        return this.pbeCipher.encrypt(Arrays.copyOfRange(bytes, offset, offset + length));
    }

    @Override
    public byte[] uncompress(byte[] bytes, int offset, int length) {
        return this.pbeCipher.decrypt(Arrays.copyOfRange(bytes, offset, offset + length));
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public OCompression configure(String options) {
        return this;
    }
}

