/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.restore;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstanceNames;
import org.sonatype.nexus.orient.DatabaseManager;
import org.sonatype.nexus.orient.DatabaseRestorer;
import org.sonatype.nexus.orient.restore.RestoreFile;
import org.sonatype.nexus.orient.restore.RestoreService;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.RESTORE)
@Singleton
public class RestoreServiceImpl
extends StateGuardLifecycleSupport
implements RestoreService {
    private final DatabaseRestorer databaseRestorer;
    private final DatabaseManager databaseManager;
    private final ApplicationVersion applicationVersion;

    @Inject
    public RestoreServiceImpl(DatabaseRestorer databaseRestorer, DatabaseManager databaseManager, ApplicationVersion applicationVersion) {
        this.databaseRestorer = databaseRestorer;
        this.databaseManager = databaseManager;
        this.applicationVersion = applicationVersion;
    }

    @Override
    protected void doStart() throws Exception {
        Map<String, RestoreFile> pending = this.checkCompleteness();
        this.checkVersions(pending);
        Set timestamps = pending.values().stream().map(f -> f.getTimestamp()).collect(Collectors.toSet());
        if (timestamps.size() > 1) {
            this.log.warn("Found mismatched timestamps {} in restore file names; will proceed with restore for backwards compatibility", (Object)timestamps);
        }
        this.log.debug("passed all restore tests, restore state: " + pending);
        DatabaseInstanceNames.DATABASE_NAMES.parallelStream().forEach(this.databaseManager::instance);
    }

    private Map<String, RestoreFile> checkCompleteness() throws IOException {
        HashMap<String, RestoreFile> pending = new HashMap<String, RestoreFile>();
        for (String name : DatabaseInstanceNames.DATABASE_NAMES) {
            RestoreFile restoreFile = this.databaseRestorer.getPendingRestore(name);
            if (restoreFile == null) continue;
            this.log.debug("found pending restore for {}", (Object)name);
            pending.put(name, restoreFile);
        }
        if (!(pending.isEmpty() || pending.keySet().equals(DatabaseInstanceNames.RECOVERABLE_DATABASE_NAMES) || pending.keySet().equals(DatabaseInstanceNames.DATABASE_NAMES))) {
            throw new IllegalStateException("Found pending database restore files for " + pending + ", but some are missing; to restore you must have files for " + DatabaseInstanceNames.RECOVERABLE_DATABASE_NAMES);
        }
        return pending;
    }

    private void checkVersions(Map<String, RestoreFile> pending) {
        String restoreVersion;
        String current = this.applicationVersion.getVersion().replace("-SNAPSHOT", "");
        Set restoreFileVersions = pending.values().stream().filter(r -> r.getVersion() != null).map(r -> r.getVersion()).collect(Collectors.toSet());
        if (restoreFileVersions.size() > 1) {
            throw new IllegalStateException("Found mismatched versions " + restoreFileVersions + " amongst restore files" + "; to restore you must use matching versions (preferably " + current + ")");
        }
        if (!restoreFileVersions.isEmpty() && (restoreVersion = (String)restoreFileVersions.iterator().next()) != null && new VersionComparator().compare(current, restoreVersion) < 0) {
            throw new IllegalStateException("Found version " + restoreVersion + " amongst restore files; to restore you" + " must use files from version " + current + " or earlier");
        }
    }
}

